<?php

class TestModel extends CFormModel
{
	public $pesel;

	public function rules()
	{
		return array(
			array('pesel', 'ext.Validators.IdentityNumberValidator'),
		);
	}
}

class TestModelNoCK extends CFormModel
{
	public $pesel;

	public function rules()
	{
		return array(
			array('pesel', 'ext.Validators.IdentityNumberValidator', 'disableChecksum' => true),
		);
	}
}

class IdentityNumberValidatorTest extends PHPUnit_Framework_TestCase
{
	/**
	 * @dataProvider dataProviderTestValidateAttribute
	 */
	public function testValidateAttribute($pesel, $errors, $class = 'TestModel')
	{
		$model = new $class();
		$model->pesel = $pesel;
		$this->assertEquals($pesel, $model->pesel);
		$model->validate();
		$this->assertEquals($model->errors, $errors);
	}

	//disableChecksum

	public function dataProviderTestValidateAttribute()
	{
		static $data = array(
			//bad
			array('qwertyuiopa', array('pesel'=>array('Pole Pesel jest nieprawidłowe.'))),
			array('invalid pesel', array('pesel'=>array('Pole Pesel jest nieprawidłowe.'))),
			array('1234', array('pesel'=>array('Pole Pesel jest nieprawidłowe.'))),
			array('', array()),
			array(null, array()),
			array(0, array()),
			array(false, array()),
			array(123, array('pesel'=>array('Pole Pesel jest nieprawidłowe.'))),
			//good string
			array('AUC738756', array()),
			array('AAG772002', array()),
			array('AAT072840', array()),
			//good number
			array('AZN487896', array()),
			array('AZV268907', array()),
			//bad string
			array('AUC738456', array('pesel'=>array('Pole Pesel ma niepoprawną sumę kontrolną.'))),
			array('AAG272002', array('pesel'=>array('Pole Pesel ma niepoprawną sumę kontrolną.'))),
			array('AAT092840', array('pesel'=>array('Pole Pesel ma niepoprawną sumę kontrolną.'))),
			//bad number
			array('AWN487896', array('pesel'=>array('Pole Pesel ma niepoprawną sumę kontrolną.'))),
			array('AZZ268907', array('pesel'=>array('Pole Pesel ma niepoprawną sumę kontrolną.'))),
			//no ck
			array('AWN487896', array(), 'TestModelNoCK'),
			array('AZZ268907', array(), 'TestModelNoCK'),
			array('qwertyuiopa', array('pesel'=>array('Pole Pesel jest nieprawidłowe.')), 'TestModelNoCK'),
			array('invalid pesel', array('pesel'=>array('Pole Pesel jest nieprawidłowe.')), 'TestModelNoCK'),
			array('1234', array('pesel'=>array('Pole Pesel jest nieprawidłowe.')), 'TestModelNoCK'),
		);
		return $data;
	}
}
